/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine.step;

import com.quantumdata.sct.dao.vo.AbstractStepVO;
import com.quantumdata.sct.dao.vo.TestStepResultVO;
import com.quantumdata.sct.engine.EngineException;
import com.quantumdata.sct.engine.IEngine;
import com.quantumdata.sct.engine.IEngineContext;
import com.quantumdata.sct.engine.step.StepEngineContext;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JPanel;

public abstract class StepEngine
implements IEngine {
    protected AbstractStepVO stepVO;
    public static final String DISPLAY_PROPERTY_RESULT = "ResultCheckBox";
    public static final String DISPLAY_PROPERTY_COUNTER = "StepCountValue";

    protected StepEngine(AbstractStepVO abstractStepVO) {
        this.stepVO = abstractStepVO;
    }

    public Collection getParameters() throws EngineException {
        return this.stepVO.getParameters();
    }

    public IEngineContext prepareContext(IEngineContext iEngineContext) throws EngineException {
        return new StepEngineContext(iEngineContext, this.stepVO);
    }

    public AbstractStepVO getStepVO() {
        return this.stepVO;
    }

    public boolean getStatus() {
        return true;
    }

    public int getError() {
        return 0;
    }

    public boolean isUserStep() {
        return false;
    }

    public int execute(IEngineContext iEngineContext) throws EngineException {
        TestStepResultVO testStepResultVO = new TestStepResultVO();
        testStepResultVO.setStepId(this.stepVO.getId().toString());
        if (this.getStatus()) {
            testStepResultVO.setStatus("PASS");
        } else {
            testStepResultVO.setStatus("FAIL");
        }
        if (this.getError() > 0) {
            int n = this.getError();
            if (n < 100 || n >= 10000) {
                testStepResultVO.setStatus("ERROR");
            }
            if (n >= 10300 && n <= 10309) {
                testStepResultVO.setStatus("FAIL");
            }
            String string = "Unknown error " + n + " occurred.  May not affect testing.";
            if (n == 1) {
                string = "Error!  Message sent to test equipment was not recognized!  (Error 1)";
            }
            if (n == 4) {
                string = "Error!  Message sent to test equipment had an invalid number of arguments! (Error 4)";
            }
            if (n == 6) {
                string = "Error!  File could not be used.  Please verify that a PCMCIA card is inserted into your 882 unit and that software is up to date.";
            }
            if (n == 99) {
                string = "Error!  Test equipment had an internal error! (Error 99)";
            }
            if (n > 9490 && n < 9500) {
                string = "DDC Error!  The test equipment was set in a mode where it attempted to read an EDID.\nPlease disable both EDID Formats and Emulate Mode in the Sink->Options menu on the TE and retest. (Error " + n + ")";
            }
            if (n == 10031) {
                string = "Error!  Feature not enabled.  Please contact Quantum Data for licensing details. (Error 10031)";
            }
            if (n == 10300) {
                string = "CEC receive error - Message was not fully received. DUT failed to send a complete message. (Error 10300)";
            }
            if (n == 10301) {
                string = "CEC receive error - Timeout on the CEC line. DUT failed to send a complete message. (Error 10301)";
            }
            if (n == 10302) {
                string = "CEC receive error - Receive buffer error. (Error 10302)";
            }
            if (n == 10303) {
                string = "CEC receive error - Start bit timing from DUT was incorrect. Please measure with oscilloscope to verify. (Error 10303)";
            }
            if (n == 10304) {
                string = "CEC receive error - Receive buffer error - message dropped. (Error 10304)";
            }
            if (n == 10305) {
                string = "CEC receive error - Signal free time not adhered to by the DUT. (Error 10305)";
            }
            if (n == 10310) {
                string = "CEC transmit error - CEC line error, send failed. (Error 10310)";
            }
            if (n == 10311) {
                string = "CEC transmit error - Arbitration was lost during send, send failed. (Error 10311)";
            }
            if (n == 10312) {
                string = "CEC transmit error - Message was not acknowledged.  Please retest. (Error 10312)";
            }
            if (n == 20000) {
                string = "Error!  Test equipment not connected to TME.  Please restart and connect.";
            }
            if (n == 20001) {
                string = "Error!  No value was entered by the tester when one was required!";
            }
            if (n == 20002) {
                string = "Error!  No selection was made by the tester when one was required!";
            }
            if (n == 20003) {
                string = "Error!  TME could not perform task (Exception occurred).";
            }
            if (n == 20005) {
                string = "Error!  Text input was not a number, when a number was expected.";
            }
            MessageOptionPane.ShowErrorMessage(this.getDisplay(new Properties()), string, "ERROR!");
            if (n == 20000) {
                System.exit(0);
            }
        }
        if (this.stepVO.getType() == 1 || this.stepVO.getType() == 4) {
            testStepResultVO.setStatus("N/A");
        }
        ((StepEngineContext)iEngineContext).setStepResultVO(testStepResultVO);
        return 0;
    }

    public abstract JPanel getDisplay(Properties var1);
}

